/***************************************************************************
 *   Copyright (C) %{CURRENT_YEAR} by %{AUTHOR} <%{EMAIL}>                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA .        *
 ***************************************************************************/

#include "%{APPNAMELC}.h"

// KF headers
#include <KParts/ReadWritePart>
#include <KPluginLoader>
#include <KPluginFactory>
#include <KActionCollection>
#include <KConfigGroup>
#include <KMessageBox>
#include <KStandardAction>
#include <KLocalizedString>

// Qt headers
#include <QApplication>
#include <QFileDialog>
#include <QAction>

%{APPNAME}::%{APPNAME}()
    : KParts::MainWindow( )
{
    // set the shell's ui resource file
    setXMLFile(QStringLiteral("%{APPNAMELC}_shell.rc"));

    // then, setup our actions
    setupActions();

    // this routine will find and load our Part.  it finds the Part by
    // name which is a bad idea usually.. but it's alright in this
    // case since our Part is made for this Shell
    KPluginLoader loader(QStringLiteral("%{APPNAMELC}part"));
    KPluginFactory* factory = loader.factory();
    if (factory) {
        // now that the Part is loaded, we cast it to a Part to get
        // our hands on it
        m_part = factory->create<KParts::ReadWritePart>(this);

        if (m_part) {
            // tell the KParts::MainWindow that this is indeed the main widget
            setCentralWidget(m_part->widget());

            // and integrate the part's GUI with the shell's
            setupGUI(ToolBar | Keys | StatusBar | Save);
            createGUI(m_part);
        }
    } else {
        // if we couldn't find our Part, we exit since the Shell by
        // itself can't do anything useful
        KMessageBox::error(this, i18n("Could not find our Part!"));
        qApp->quit();
        // we return here, cause qApp->quit() only means "exit the
        // next time we enter the event loop...
        return;
    }
}

%{APPNAME}::~%{APPNAME}()
{
}

void %{APPNAME}::load(const QUrl& url)
{
    m_part->openUrl(url);
}

void %{APPNAME}::setupActions()
{
    KStandardAction::openNew(this, SLOT(fileNew()), actionCollection());
    KStandardAction::open(this, SLOT(fileOpen()), actionCollection());

    KStandardAction::quit(qApp, SLOT(closeAllWindows()), actionCollection());
}

void %{APPNAME}::saveProperties(KConfigGroup & /*config*/)
{
    // the 'config' object points to the session managed
    // config file.  anything you write here will be available
    // later when this app is restored
}

void %{APPNAME}::readProperties(const KConfigGroup & /*config*/)
{
    // the 'config' object points to the session managed
    // config file.  this function is automatically called whenever
    // the app is being restored.  read in here whatever you wrote
    // in 'saveProperties'
}

void %{APPNAME}::fileNew()
{
    // this slot is called whenever the File->New menu is selected,
    // the New shortcut is pressed (usually CTRL+N) or the New toolbar
    // button is clicked

    // About this function, the style guide (
    // http://developer.kde.org/documentation/standards/kde/style/basics/index.html )
    // says that it should open a new window if the document is _not_
    // in its initial state.  This is what we do here..
    if (!m_part->url().isValid() || m_part->isModified()) {
        (new %{APPNAME})->show();
    };
}

void %{APPNAME}::fileOpen()
{
    // this slot is called whenever the File->Open menu is selected,
    // the Open shortcut is pressed (usually CTRL+O) or the Open toolbar
    // button is clicked
    const QUrl url = QFileDialog::getOpenFileUrl(this);

    if (url.isValid()) {
        // About this function, the style guide (
        // http://developer.kde.org/documentation/standards/kde/style/basics/index.html )
        // says that it should open a new window if the document is _not_
        // in its initial state.  This is what we do here..
        if (m_part->url().isEmpty() && ! m_part->isModified()) {
            // we open the file in this window...
            load(url);
        } else {
            // we open the file in a new window...
            %{APPNAME}* newWin = new %{APPNAME};
            newWin->load(url);
            newWin->show();
        }
    }
}
